"use strict";
//
// Copyright 2023 Signal Messenger, LLC.
// SPDX-License-Identifier: AGPL-3.0-only
//
Object.defineProperty(exports, "__esModule", { value: true });
const crypto_1 = require("crypto");
const ByteArray_1 = require("../internal/ByteArray");
const Constants_1 = require("../internal/Constants");
const Native = require("../../../Native");
const CreateCallLinkCredentialPresentation_1 = require("./CreateCallLinkCredentialPresentation");
class CreateCallLinkCredential extends ByteArray_1.default {
    constructor(contents) {
        super(contents, Native.CreateCallLinkCredential_CheckValidContents);
    }
    present(roomId, userId, serverParams, callLinkParams) {
        const random = (0, crypto_1.randomBytes)(Constants_1.RANDOM_LENGTH);
        return this.presentWithRandom(roomId, userId, serverParams, callLinkParams, random);
    }
    presentWithRandom(roomId, userId, serverParams, callLinkParams, random) {
        return new CreateCallLinkCredentialPresentation_1.default(Native.CreateCallLinkCredential_PresentDeterministic(this.contents, roomId, userId.getServiceIdFixedWidthBinary(), serverParams.contents, callLinkParams.contents, random));
    }
}
exports.default = CreateCallLinkCredential;
//# sourceMappingURL=CreateCallLinkCredential.js.map